
//
// To jest przykadowy kod z podrozdziau 9.7.4 Stae funkcje skadowe ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>

using namespace std;

//------------------------------------------------------------------------------

class Date {
public:
    enum Month {
        jan=1, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec
    };

    Date(int yy, Month mm, int dd) : y(yy), m(mm), d(dd) {}

    int   day()   const;         // Staa skadowa: nie moe modyfikowa obiektw.
    Month month() const;         // Staa skadowa: nie moe modyfikowa obiektw.
    int   year()  const;         // Staa skadowa: nie moe modyfikowa obiektw.

    void add_day(int n);         // Niestaa skadowa: moe modyfikowa obiekty.
    void add_month(int n);       // Niestaa skadowa: moe modyfikowa obiekty.
    void add_year(int n);        // Niestaa skadowa: moe modyfikowa obiekty.
private:
    int   y;                     // Rok
    Month m;
    int   d;                     // Dzie miesica
};

//------------------------------------------------------------------------------

int Date::day() const
{
    //++d;        // Bd: prba zmodyfikowania obiektu za pomoc staej funkcji skadowej.
    return d;
}

//------------------------------------------------------------------------------

void Date::add_day(int n) {}

//------------------------------------------------------------------------------

void some_function(Date& d, const Date& start_of_term)
{
    int a = d.day();             // ok
    int b = start_of_term.day(); // Powinno by dobrze (czemu?).
    d.add_day(3);                // dobrze
    //start_of_term.add_day(3);  // bd
}

//------------------------------------------------------------------------------

int main()
{
    Date d(2000, Date::jan, 20);
    const Date cd(2001, Date::feb, 21);

    cout << d.day() << " - " << cd.day() << endl;        // ok
    d.add_day(1);                // ok
    //cd.add_day(1);             // Bd: cd jest const.
    some_function(d,cd);
    //some_function(cd,d);       // Bd: cd jest const.
    return 0;
}

//------------------------------------------------------------------------------
